<?php
if (!defined('_PS_VERSION_')) {
    exit;
}

class MapCosmos extends Module
{
    public function __construct()
    {
        $this->name = 'mapcosmos';
        $this->tab = 'front_office_features';
        $this->version = '1.0.0';
        $this->author = 'Map Cosmos';
        $this->need_instance = 0;
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('Map Cosmos');
        $this->description = $this->l('Install the Map Cosmos store locator on your page.');

        $this->ps_versions_compliancy = ['min' => '1.7.0.0', 'max' => _PS_VERSION_];
    }

    public function install()
    {
        return parent::install()
            && $this->registerHook('filterCmsContent')
            && Configuration::updateValue('map_cosmos_code', '');
    }

    public function uninstall()
    {
        Configuration::deleteByName('map_cosmos_code');
        return parent::uninstall();
    }

    /**
     * Back office configuration form
     */
    public function getContent()
    {
        $output = '';

        if (Tools::isSubmit('submitMapCosmosCode')) {
            $widgetCode = Tools::getValue('map_cosmos_code');
            Configuration::updateValue('map_cosmos_code', $widgetCode, true);
            $output .= $this->displayConfirmation($this->l('Settings updated.'));
        }

        return $output . $this->renderForm();
    }

    protected function renderForm()
    {
        $fieldsForm[0]['form'] = [
            'legend' => [
                'title' => $this->l('Widget Settings'),
                'icon' => 'icon-cogs'
            ],
            'input' => [
                [
                    'type' => 'textarea',
                    'label' => $this->l('Map Cosmos installation code'),
                    'name' => 'map_cosmos_code',
                    'lang' => false,
                    'cols' => 60,
                    'rows' => 10,
                    'desc' => $this->l('Enter the full Map Cosmos installation code from your customer panel'),
                ],
                [
                    'type' => 'text',
                    'readonly' => true,
                    'lang' => false,
                    'label' => $this->l('Paste this code into your CMS page content'),
                    'name' => 'map_cosmos_placeholder',
                ]
            ],
            'submit' => [
                'title' => $this->l('Save'),
                'class' => 'btn btn-default pull-right'
            ]
        ];

        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->module = $this;
        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submitMapCosmosCode';
        $helper->currentIndex = AdminController::$currentIndex . '&configure=' . $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');

        $helper->fields_value['map_cosmos_code'] = Configuration::get('map_cosmos_code');
        $helper->fields_value['map_cosmos_placeholder'] = '{map_cosmos}';

        return $helper->generateForm($fieldsForm);
    }

    /**
     * Hook into CMS content
     */
    public function hookFilterCmsContent($params)
    {
        $widgetHtml = Configuration::get('map_cosmos_code', null, null);
        if ($widgetHtml && isset($params['object']['content'])) {
            $widgetHtml = str_replace('type="text/javascript"', 'type="text/javascript" async', $widgetHtml);
            $params['object']['content'] = str_replace('{map_cosmos}', $widgetHtml, $params['object']['content']);
        }
        return $params;
    }
}
