const { registerBlockType } = wp.blocks;
const { useBlockProps } = wp.blockEditor;
const { createElement } = wp.element;

const customIcon = wp.element.createElement('img', {
    src: '/wp-content/plugins/mapcosmos/icon.png',
    alt: 'MapCosmos Logo',
    style: { width: 24, height: 24 }
});

registerBlockType('mapcosmos/installer', {
    title: 'MapCosmos',
    icon: customIcon,
    category: 'widgets',
    attributes: { code: { type: 'string', default: '' } },

    edit: (props) => {
        const blockProps = useBlockProps();
        return createElement(
            'div',
            blockProps,
            createElement('textarea', {
                style: { width: '100%', minHeight: '120px' },
                placeholder: 'Paste your MapCosmos installation code here...',
                value: props.attributes.code,
                onChange: (e) => props.setAttributes({ code: e.target.value }),
            }),
            createElement(
                'p',
                { style: { fontSize: '13px', color: '#666', marginTop: '0' } },
                [
                    'Need installation code? Visit ',
                    createElement(
                        'a',
                        {
                            href: 'https://mapcosmos.com/article/how-to-set-up-your-mapcosmos-store-locator-and-get-the-installation-code',
                            target: '_blank',
                            rel: 'noopener noreferrer',
                            style: { color: '#007cba', textDecoration: 'none' },
                        },
                        'MapCosmos.com'
                    ),
                ]
            )
        );
    },

    save() {
        return null; // dynamic block — frontend handled by PHP
    },
});
