<?php
/**
 * Plugin Name: MapCosmos
 * Description: MapCosmos installation module
 * Version: 1.0
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Author: MapCosmos B.V.
 */

if ( ! defined( 'ABSPATH' ) ) exit;

add_action('init', function() {

    $icon_url = esc_url_raw( plugins_url( 'icon.png', __FILE__ ) );

    wp_add_inline_script(
        'mapcosmos-block-editor',
        'const MAPCOSMOS_ICON_URL = ' . wp_json_encode( $icon_url ) . ';',
        'before'
    );

    register_block_type(__DIR__ . '/block.json', [
        'editor_script' => 'mapcosmos-block-editor',
        'render_callback' => 'mapcosmos_render_block',
    ]);
});

function mapcosmos_render_block($attributes) {
    if (empty($attributes['code'])) return '';

    $allowed = [
        'script' => ['type'=>true,'src'=>true,'async'=>true],
        'div'    => ['id'=>true,'class'=>true,'style'=>true],
    ];

    return wp_kses($attributes['code'], $allowed);
}
